<?php defined('SYSPATH') or die('No direct script access.');

class Helper{

    public static function isCuttedStorage(){
        return Arr::get(
            Kohana::$config->load('init')->as_array(),
            'cut'
        );
    }

    public static function getConfigByName($name, $config = 'config'){
        $config = Kohana::$config->load($config)->as_array();
        foreach($config as $k => $c){
            foreach($c as $n => $limit){
                if($name == $n){
                    return [
                        'limit' => $limit,
                        'database' => $k,
                        'name' => $name
                    ];
                }
            }
        }
    }

    public static function getCounter($table){
        $result = DB::select('id')
            ->from('counter')
            ->where('name', '=', $table)
            ->execute()
            ->as_array();
        return $result[0]['id'];
    }

    public static function updCounter($max_id, $table){
        DB::update('counter')
            ->set(['id' => $max_id])
            ->where('name', '=', $table)
            ->execute();
    }

    public static function getCurrentDB(){
        return Kohana::$config->load('init.database');
    }

    public static function getCurrentSphinx(){
        return Kohana::$config->load('init.sphinx');
    }

    public static function locationToInt($str){
        return intval(ord($str{0}) << 8) + ord($str{1});
    }

    public static function isJson($str) {
        json_decode($str);
        return (json_last_error() == JSON_ERROR_NONE);
    }
}
